/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader;

import com.simibubi.create.foundation.utility.Lang;
import java.util.Collections;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CPLTags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return CPLTags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return CPLTags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return CPLTags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return CPLTags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void register() {
        AllEntityTags.register();
    }

    public static enum AllEntityTags {
        CHUNK_LOADER_CAPTURABLE;

        public final TagKey<EntityType<?>> tag;
        public final boolean alwaysDatagen;

        private AllEntityTags() {
            this(NameSpace.MOD);
        }

        private AllEntityTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private AllEntityTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private AllEntityTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CPLTags.optionalTag(ForgeRegistries.ENTITY_TYPES, id) : TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(EntityType<?> type) {
            return type.m_204039_(this.tag);
        }

        public boolean matches(Entity entity) {
            return this.matches(entity.m_6095_());
        }

        private static void register() {
        }
    }

    public static enum NameSpace {
        MOD("create_power_loader", false, true),
        FORGE("forge");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

